#include <stdio.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>
#include <unistd.h>
#include <linux/unistd.h>
#include <stdlib.h>
#include <sys/resource.h>




static struct param_transtbl resource_table[] = {
	{ X86_RLIMIT_CPU, RLIMIT_CPU },
	{ X86_RLIMIT_FSIZE, RLIMIT_FSIZE },
	{ X86_RLIMIT_DATA, RLIMIT_DATA },
	{ X86_RLIMIT_STACK, RLIMIT_STACK },
	{ X86_RLIMIT_CORE, RLIMIT_CORE },
	{ X86_RLIMIT_RSS, RLIMIT_RSS },
	{ X86_RLIMIT_NPROC, RLIMIT_NPROC },
	{ X86_RLIMIT_NOFILE, RLIMIT_NOFILE },
	{ X86_RLIMIT_MEMLOCK, RLIMIT_MEMLOCK }
};

#define RESOURCE_TABLE_SIZE	sizeof(resource_table)/sizeof(struct param_transtbl)

extern int x86_to_alpha_param(int, struct param_transtbl *, int);

int do_getrlimit(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int resource = x86_to_alpha_param(a0, resource_table, RESOURCE_TABLE_SIZE);
    struct rlimit 	alpha_rlim;
    struct x86_rlimit *	x86_rlim = ARG_TO_POINTER(a1);
    int retval;

    retval = getrlimit(resource, &alpha_rlim);
    if(retval == 0) {
	x86_rlim->rlim_cur = alpha_rlim.rlim_cur;
	x86_rlim->rlim_max = alpha_rlim.rlim_max;
	return(0);
    }
    else {
	return(-alpha_to_intel_errno(errno));
    }
}

int do_setrlimit(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int resource = x86_to_alpha_param(a0, resource_table, RESOURCE_TABLE_SIZE);
    struct rlimit 	alpha_rlim;
    struct x86_rlimit *	x86_rlim = ARG_TO_POINTER(a1);
    int retval;

    alpha_rlim.rlim_cur = x86_rlim->rlim_cur;
    alpha_rlim.rlim_max = x86_rlim->rlim_max;
    retval = setrlimit(resource, &alpha_rlim);
    if(retval == 0) {
	return(0);
    }
    else {
	return(-alpha_to_intel_errno(errno));
    }
}

