/*
 * ioctl_list.c
 *
 * by Adam Stachelek
 */

#include <ioctl_thunk.h>
#include <ioctls.h>
#include <asm/termiobits.h>
#include <termios.h>
#include <asm/termios.h>
#include <linux/if.h>

bitmask_transtbl iflag_tbl[] = {
        { X86_IGNBRK, X86_IGNBRK, IGNBRK, IGNBRK },
        { X86_BRKINT, X86_BRKINT, BRKINT, BRKINT },
        { X86_IGNPAR, X86_IGNPAR, IGNPAR, IGNPAR },
        { X86_PARMRK, X86_PARMRK, PARMRK, PARMRK },
        { X86_INPCK, X86_INPCK, INPCK, INPCK },
        { X86_ISTRIP, X86_ISTRIP, ISTRIP, ISTRIP },
        { X86_INLCR, X86_INLCR, INLCR, INLCR },
        { X86_IGNCR, X86_IGNCR, IGNCR, IGNCR },
        { X86_ICRNL, X86_ICRNL, ICRNL, ICRNL },
        { X86_IUCLC, X86_IUCLC, IUCLC, IUCLC },
        { X86_IXON, X86_IXON, IXON, IXON },
        { X86_IXANY, X86_IXANY, IXANY, IXANY },
        { X86_IXOFF, X86_IXOFF, IXOFF, IXOFF },
        { X86_IMAXBEL, X86_IMAXBEL, IMAXBEL, IMAXBEL },
        { 0, 0, 0, 0 }
};

bitmask_transtbl oflag_tbl[] = {
	{ X86_OPOST, X86_OPOST, OPOST, OPOST },
	{ X86_OLCUC, X86_OLCUC, OLCUC, OLCUC },
	{ X86_ONLCR, X86_ONLCR, ONLCR, ONLCR },
	{ X86_OCRNL, X86_OCRNL, OCRNL, OCRNL },
	{ X86_ONOCR, X86_ONOCR, ONOCR, ONOCR },
	{ X86_ONLRET, X86_ONLRET, ONLRET, ONLRET },
	{ X86_OFILL, X86_OFILL, OFILL, OFILL },
	{ X86_OFDEL, X86_OFDEL, OFDEL, OFDEL },
	{ X86_NLDLY, X86_NL0, NLDLY, NL0 },
	{ X86_NLDLY, X86_NL1, NLDLY, NL1 },
	{ X86_CRDLY, X86_CR0, CRDLY, CR0 },
	{ X86_CRDLY, X86_CR1, CRDLY, CR1 },
	{ X86_CRDLY, X86_CR2, CRDLY, CR2 },
	{ X86_CRDLY, X86_CR3, CRDLY, CR3 },
	{ X86_TABDLY, X86_TAB0, TABDLY, TAB0 },
	{ X86_TABDLY, X86_TAB1, TABDLY, TAB1 },
	{ X86_TABDLY, X86_TAB2, TABDLY, TAB2 },
	{ X86_TABDLY, X86_TAB3, TABDLY, TAB3 },
	{ X86_BSDLY, X86_BS0, BSDLY, BS0 },
	{ X86_BSDLY, X86_BS1, BSDLY, BS1 },
	{ X86_VTDLY, X86_VT0, VTDLY, VT0 },
	{ X86_VTDLY, X86_VT1, VTDLY, VT1 },
	{ X86_FFDLY, X86_FF0, FFDLY, FF0 },
	{ X86_FFDLY, X86_FF1, FFDLY, FF1 },
	{ 0, 0, 0, 0 }
};

bitmask_transtbl cflag_tbl[] = {
	{ X86_CBAUD, X86_B0, CBAUD, B0 },
	{ X86_CBAUD, X86_B50, CBAUD, B50 },
	{ X86_CBAUD, X86_B75, CBAUD, B75 },
	{ X86_CBAUD, X86_B110, CBAUD, B110 },
	{ X86_CBAUD, X86_B134, CBAUD, B134 },
	{ X86_CBAUD, X86_B150, CBAUD, B150 },
	{ X86_CBAUD, X86_B200, CBAUD, B200 },
	{ X86_CBAUD, X86_B300, CBAUD, B300 },
	{ X86_CBAUD, X86_B600, CBAUD, B600 },
	{ X86_CBAUD, X86_B1200, CBAUD, B1200 },
	{ X86_CBAUD, X86_B1800, CBAUD, B1800 },
	{ X86_CBAUD, X86_B2400, CBAUD, B2400 },
	{ X86_CBAUD, X86_B4800, CBAUD, B4800 },
	{ X86_CBAUD, X86_B9600, CBAUD, B9600 },
	{ X86_CBAUD, X86_B19200, CBAUD, B19200 },
	{ X86_CBAUD, X86_B38400, CBAUD, B38400 },
	{ X86_CBAUD, X86_B57600, CBAUD, B57600 },
	{ X86_CBAUD, X86_B115200, CBAUD, B115200 },
	{ X86_CBAUD, X86_B230400, CBAUD, B230400 },
	{ X86_CBAUD, X86_B460800, CBAUD, B460800 },
	{ X86_CSIZE, X86_CS5, CSIZE, CS5 },
	{ X86_CSIZE, X86_CS6, CSIZE, CS6 },
	{ X86_CSIZE, X86_CS7, CSIZE, CS7 },
	{ X86_CSIZE, X86_CS8, CSIZE, CS8 },
	{ X86_CSTOPB, X86_CSTOPB, CSTOPB, CSTOPB },
	{ X86_CREAD, X86_CREAD, CREAD, CREAD },
	{ X86_PARENB, X86_PARENB, PARENB, PARENB },
	{ X86_PARODD, X86_PARODD, PARODD, PARODD },
	{ X86_HUPCL, X86_HUPCL, HUPCL, HUPCL },
	{ X86_CLOCAL, X86_CLOCAL, CLOCAL, CLOCAL },
	{ X86_CRTSCTS, X86_CRTSCTS, CRTSCTS, CRTSCTS },
	{ 0, 0, 0, 0 }
};

bitmask_transtbl lflag_tbl[] = {
	{ X86_ISIG, X86_ISIG, ISIG, ISIG },
	{ X86_ICANON, X86_ICANON, ICANON, ICANON },
	{ X86_XCASE, X86_XCASE, XCASE, XCASE },
	{ X86_ECHO, X86_ECHO, ECHO, ECHO },
	{ X86_ECHOE, X86_ECHOE, ECHOE, ECHOE },
	{ X86_ECHOK, X86_ECHOK, ECHOK, ECHOK },
	{ X86_ECHONL, X86_ECHONL, ECHONL, ECHONL },
	{ X86_NOFLSH, X86_NOFLSH, NOFLSH, NOFLSH },
	{ X86_TOSTOP, X86_TOSTOP, TOSTOP, TOSTOP },
	{ X86_ECHOCTL, X86_ECHOCTL, ECHOCTL, ECHOCTL },
	{ X86_ECHOPRT, X86_ECHOPRT, ECHOPRT, ECHOPRT },
	{ X86_ECHOKE, X86_ECHOKE, ECHOKE, ECHOKE },
	{ X86_FLUSHO, X86_FLUSHO, FLUSHO, FLUSHO },
	{ X86_PENDIN, X86_PENDIN, PENDIN, PENDIN },
	{ X86_IEXTEN, X86_IEXTEN, IEXTEN, IEXTEN },
	{ 0, 0, 0, 0 }
};

argtype tty_struct_list [] = { 
  TYPE_INT, TYPE_TTY_DRIVER, TYPE_TTY_LDISC, TYPE_PTR, 
  TYPE_PTR, TYPE_INT, TYPE_INT, TYPE_SHORT, TYPE_ULONG, TYPE_INT, TYPE_WINSIZE,
  TYPE_CHAR, TYPE_CHAR, TYPE_PTR, TYPE_PTR, TYPE_TTY_FLIP_BUFFER, TYPE_INT, 
  TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_INT, TYPE_CHAR, TYPE_SHORT, 
  TYPE_INT, TYPE_INT, TYPE_PTR, TYPE_PTR, TYPE_INT, TYPE_INT, TYPE_INT,
  TYPE_PTR, TYPE_INT, TYPE_ULONG, TYPE_INT, TYPE_NULL };

argtype tty_flip_buffer_list [] = { 
  TYPE_TQ_STRUCT, TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, 1024),
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, 1024), TYPE_PTR, 
  TYPE_PTR, TYPE_INT, TYPE_INT, TYPE_NULL };

argtype tty_driver_list [] = { 
  TYPE_INT, TYPE_PTR, TYPE_INT, TYPE_SHORT, TYPE_SHORT, 
  TYPE_SHORT, TYPE_SHORT, TYPE_SHORT, TYPE_TERMIOS, TYPE_INT, TYPE_PTR, 
  TYPE_PTR, 
  // these 3 are double pointers 
  TYPE_PTR, TYPE_PTR, TYPE_PTR,
  //
  TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, 
  TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, 
  TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_NULL };

argtype tty_ldisc_list [] = { 
  TYPE_INT, TYPE_INT, TYPE_INT, TYPE_PTR, TYPE_PTR, TYPE_PTR,
  TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, TYPE_PTR, 
  TYPE_PTR, TYPE_PTR, TYPE_NULL };

argtype async_struct_list [] = { 
  TYPE_INT, TYPE_INT, TYPE_INT, TYPE_INT, TYPE_INT, 
  TYPE_INT, TYPE_INT, TYPE_PTR, TYPE_INT, TYPE_INT, TYPE_INT, TYPE_INT, 
  TYPE_INT, TYPE_INT, TYPE_INT, TYPE_SHORT, TYPE_SHORT, TYPE_INT, TYPE_INT, 
  TYPE_INT, TYPE_ULONG, TYPE_ULONG, TYPE_INT, TYPE_INT, TYPE_INT, TYPE_LONG, 
  TYPE_LONG, TYPE_CHAR, TYPE_INT, TYPE_INT, TYPE_INT, TYPE_TQ_STRUCT, 
  TYPE_TQ_STRUCT, TYPE_TERMIOS, TYPE_TERMIOS, TYPE_PTR, TYPE_PTR, TYPE_PTR, 
  TYPE_ASYNC_ICOUNT, TYPE_PTR, TYPE_PTR, TYPE_NULL };

argtype tq_struct_list [] = { 
  TYPE_PTR, TYPE_INT, TYPE_PTR, TYPE_PTR, TYPE_NULL };

argtype async_icount_list [] = { 
  TYPE_INT, TYPE_INT, TYPE_INT, TYPE_INT, TYPE_NULL };

argtype winsize_list [] = {
  TYPE_SHORT, TYPE_SHORT, TYPE_SHORT, TYPE_SHORT, TYPE_NULL };

argtype serial_multiport_struct_list [] = {
  TYPE_INT, TYPE_INT, TYPE_CHAR, TYPE_CHAR, TYPE_INT, TYPE_CHAR, TYPE_CHAR,
  TYPE_INT, TYPE_CHAR, TYPE_CHAR, TYPE_INT, TYPE_CHAR, TYPE_CHAR, TYPE_INT, 
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_INT, 32), TYPE_NULL };

argtype serial_icounter_struct_list [] = {
  TYPE_INT, TYPE_INT, TYPE_INT, TYPE_INT, TYPE_ARRAY, 
  MK_ARRAY_INFO (TYPE_INT, 16), TYPE_NULL };

argtype sockaddr_list [] = {
  TYPE_SHORT, TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, 14), TYPE_NULL };

argtype rtentry_list [] = {
  TYPE_ULONG, TYPE_SOCKADDR, TYPE_SOCKADDR, TYPE_SOCKADDR, 
  TYPE_SHORT, TYPE_SHORT, TYPE_ULONG, TYPE_PTR, TYPE_SHORT, TYPE_PTR, 
  TYPE_ULONG, TYPE_ULONG, TYPE_SHORT, TYPE_NULL };

argtype ifmap_list [] = {
  TYPE_ULONG, TYPE_ULONG, TYPE_SHORT, TYPE_CHAR, TYPE_CHAR, TYPE_CHAR, 
  TYPE_NULL };

/* The *_ifreq_list arrays deal with the fact that struct ifreq has unions */

argtype sockaddr_ifreq_list [] = {
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_SOCKADDR, TYPE_NULL };

argtype short_ifreq_list [] = {
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_SHORT, TYPE_NULL };

argtype int_ifreq_list [] = {
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_INT, TYPE_NULL };

argtype ifmap_ifreq_list [] = {
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_IFMAP, TYPE_NULL };

argtype char_ifreq_list [] = {
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_ARRAY, 
  MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_NULL };

argtype ptr_ifreq_list [] = {
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, IFNAMSIZ), TYPE_PTR, TYPE_NULL };

argtype ifconf_list [] = {
  TYPE_INT, TYPE_PTR, TYPE_NULL };

argtype arpreq_list [] = {
  TYPE_SOCKADDR, TYPE_SOCKADDR, TYPE_INT, TYPE_SOCKADDR, 
  TYPE_ARRAY, MK_ARRAY_INFO (TYPE_CHAR, 16), TYPE_NULL };

argtype arpreq_old_list [] = {
  TYPE_SOCKADDR, TYPE_SOCKADDR, TYPE_INT, TYPE_SOCKADDR, TYPE_NULL };

argtype br_stat_list [] = {
  TYPE_INT, TYPE_BRIDGE_DATA, TYPE_PORT_DATA, TYPE_PORT_DATA, 
  TYPE_PORT_DATA, TYPE_PORT_DATA, TYPE_PORT_DATA, TYPE_PORT_DATA, 
  TYPE_PORT_DATA, TYPE_PORT_DATA, TYPE_NULL };

argtype Bridge_data_list [] = {
  TYPE_BRIDGE_ID_T, TYPE_INT, TYPE_INT, TYPE_SHORT, 
  TYPE_SHORT, TYPE_SHORT, TYPE_BRIDGE_ID_T, TYPE_SHORT, TYPE_SHORT, TYPE_SHORT,
  TYPE_INT, TYPE_INT, TYPE_SHORT, TYPE_SHORT, TYPE_INT, TYPE_INT, TYPE_NULL };

argtype Port_data_list [] = {
  TYPE_SHORT, TYPE_INT, TYPE_INT, TYPE_BRIDGE_ID_T, TYPE_INT,
  TYPE_BRIDGE_ID_T, TYPE_SHORT, TYPE_INT, TYPE_INT, TYPE_PTR, TYPE_PTR, 
  TYPE_NULL }; 

argtype bridge_id_t_list [] = {
  TYPE_ULONG, TYPE_NULL };

/* struct_table: Note, these MUST be in the same order as the struct types come
 * in the typedef for argtype
 */
argtype *struct_table [] = {
  winsize_list,
  tq_struct_list,
  async_struct_list,
  async_icount_list,
  tty_struct_list,
  tty_driver_list,
  tty_ldisc_list,
  tty_flip_buffer_list,
  serial_multiport_struct_list,
  serial_icounter_struct_list,
  sockaddr_list,
  rtentry_list,
  ifmap_list,
  sockaddr_ifreq_list,
  short_ifreq_list,
  int_ifreq_list,
  ifmap_ifreq_list,
  char_ifreq_list,
  ptr_ifreq_list,
  ifconf_list,
  arpreq_list,
  arpreq_old_list,
  br_stat_list,
  Bridge_data_list,
  Port_data_list,
  bridge_id_t_list
};


/* ioctl_table: holds command numbers, and type and usage information for the
 * argument
 */
ioctl_descriptor ioctl_table[] = {
  { X86_TCGETS, TCGETS, "TCGETS", do_termios_ioctl, _IOC_READ, 0 },
  { X86_TCSETS, TCSETS, "TCSETS", do_termios_ioctl, _IOC_WRITE, 0 },
  { X86_TCSETSF, TCSETSF, "TCSETSF", do_termios_ioctl, _IOC_WRITE, 0 },
  { X86_TCSETSW, TCSETSW, "TCSETSW", do_termios_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCGWINSZ, TIOCGWINSZ, "TIOCGWINSZ", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSWINSZ, TIOCSWINSZ, "TIOCSWINSZ", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_FIONREAD, FIONREAD, "FIONREAD", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TCGETA, TCGETA, "TCGETA", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TCSETA, TCSETA, "TCSETA", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TCSETAW, TCSETAW, "TCSETAW", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TCSETAF, TCSETAF, "TCSETAF", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TCSBRK, TCSBRK, "TCSBRK", do_int_ioctl, _IOC_NONE, 0 },
  { X86_TCSBRKP, TCSBRKP, "TCSBRKP", do_int_ioctl, _IOC_NONE, 0 },
  { X86_TCXONC, TCXONC, "TCXONC", do_int_ioctl, _IOC_NONE, 0 },
  { X86_TCFLSH, TCFLSH, "TCFLSH", do_int_ioctl, _IOC_NONE, 0 },
  { X86_TIOCEXCL, TIOCEXCL, "TIOCEXCL", do_void_ioctl, _IOC_NONE, 0 },
  { X86_TIOCNXCL, TIOCNXCL, "TIOCNXCL", do_void_ioctl, _IOC_NONE, 0 },
  { X86_TIOCSCTTY, TIOCSCTTY, "TIOCSCTTY", do_int_ioctl, _IOC_NONE, 0 },
  { X86_TIOCGPGRP, TIOCGPGRP, "TIOCGPGRP", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSPGRP, TIOCSPGRP, "TIOCSPGRP", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCOUTQ, TIOCOUTQ, "TIOCOUTQ", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSTI, TIOCSTI, "TIOCSTI", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCMGET, TIOCMGET, "TIOCMGET", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCMBIS, TIOCMBIS, "TIOCMBIS", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCMBIC, TIOCMBIC, "TIOCMBIC", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCMSET, TIOCMSET, "TIOCMSET", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCGSOFTCAR, TIOCGSOFTCAR, "TIOCGSOFTCAR", do_longptr_ioctl, _IOC_READ, 0 }, 
  { X86_TIOCSSOFTCAR, TIOCSSOFTCAR, "TIOCSSOFTCAR", do_longptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCLINUX, TIOCLINUX, "TIOCLINUX", do_ptr_ioctl, _IOC_READ | _IOC_WRITE, 0 },
  { X86_TIOCCONS, TIOCCONS, "TIOCCONS", do_void_ioctl, _IOC_NONE, 0 },
  { X86_TIOCGSERIAL, TIOCGSERIAL, "TIOCGSERIAL", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSSERIAL, TIOCSSERIAL, "TIOCSSERIAL", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCPKT, TIOCPKT, "TIOCPKT", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_FIONBIO, FIONBIO, "FIONBIO", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCNOTTY, TIOCNOTTY, "TIOCNOTTY", do_void_ioctl, _IOC_NONE, 0 },
  { X86_TIOCGETD, TIOCGETD, "TIOCGETD", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSETD, TIOCSETD, "TIOCSETD", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCTTYGSTRUCT, TIOCTTYGSTRUCT, "TIOCCTTYGSTRUCT", do_struct_ioctl, _IOC_READ, tty_struct_list },
  { X86_FIOCLEX, FIOCLEX, "FIOCLEX", do_void_ioctl, _IOC_NONE, 0 },
  { X86_FIONCLEX, FIONCLEX, "FIONCLEX", do_void_ioctl, _IOC_NONE, 0 },
  { X86_FIOASYNC, FIOASYNC, "FIOASYNC", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCGLCKTRMIOS, TIOCGLCKTRMIOS, "TIOCGLCKTRMIOS", do_termios_ioctl, _IOC_READ, 0 },
  { X86_TIOCSLCKTRMIOS, TIOCSLCKTRMIOS, "TIOCSLCKTRMIOS", do_termios_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCSERCONFIG, TIOCSERCONFIG, "TIOCSERCONFIG", do_void_ioctl, _IOC_NONE, 0 },
  { X86_TIOCSERGWILD, TIOCSERGWILD, "TIOCSERGWILD", do_longptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSERSWILD, TIOCSERSWILD, "TIOCSERSWILD", do_longptr_ioctl, _IOC_WRITE, 0 },
  { X86_TIOCSERGETLSR, TIOCSERGETLSR, "TIOCSERGETLSR", do_ptr_ioctl, _IOC_READ, 0 },
  { X86_TIOCSERGSTRUCT, TIOCSERGSTRUCT, "TIOCSERGSTRUCT", do_struct_ioctl, _IOC_READ, async_struct_list },
  { X86_TIOCSERGETMULTI, TIOCSERGETMULTI, "TIOCSERGETMULTI", do_struct_ioctl, _IOC_READ, serial_multiport_struct_list },
  { X86_TIOCSERSETMULTI, TIOCSERSETMULTI, "TIOCSERSETMULTI", do_struct_ioctl, _IOC_WRITE, serial_multiport_struct_list },
  { X86_TIOCMIWAIT, TIOCMIWAIT, "TIOCMIWAIT", do_int_ioctl, _IOC_NONE, 0 },
  { X86_TIOCGICOUNT, TIOCGICOUNT, "TIOCGICOUNT", do_struct_ioctl, _IOC_READ, serial_icounter_struct_list }, 
  { X86_SIOCADDRT, SIOCADDRT, "SIOCADDRT", do_struct_ioctl, _IOC_WRITE, rtentry_list },
  { X86_SIOCDELRT, SIOCDELRT, "SIOCDELRT", do_struct_ioctl, _IOC_WRITE, rtentry_list },
  { X86_SIOCGIFNAME, SIOCGIFNAME, "SIOCGIFNAME", do_ptr_ioctl, _IOC_WRITE | _IOC_READ, 0 },
  { X86_SIOCGIFFLAGS, SIOCGIFFLAGS, "SIOCGIFFLAGS", do_struct_ioctl, _IOC_WRITE | _IOC_READ, short_ifreq_list },
  { X86_SIOCSIFFLAGS, SIOCSIFFLAGS, "SIOCSIFFLAGS", do_struct_ioctl, _IOC_WRITE, short_ifreq_list },
  { X86_SIOCGIFADDR, SIOCGIFADDR, "SIOCGIFADDR", do_struct_ioctl, _IOC_WRITE | _IOC_READ, sockaddr_ifreq_list },
  { X86_SIOCSIFADDR, SIOCSIFADDR, "SIOCSIFADDR", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCGIFBRDADDR, SIOCGIFBRDADDR, "SIOCGIFBRDADDR", do_struct_ioctl, _IOC_WRITE | _IOC_READ, sockaddr_ifreq_list },
  { X86_SIOCSIFBRDADDR, SIOCSIFBRDADDR, "SIOCSIFBRDADDR", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCGIFDSTADDR, SIOCGIFDSTADDR, "SIOCGIFDSTADDR", do_struct_ioctl, _IOC_WRITE | _IOC_READ, sockaddr_ifreq_list },
  { X86_SIOCSIFDSTADDR, SIOCSIFDSTADDR, "SIOCSIFDSTADDR", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCGIFNETMASK, SIOCGIFNETMASK, "SIOCGIFNETMASK", do_struct_ioctl, _IOC_WRITE | _IOC_READ, sockaddr_ifreq_list },
  { X86_SIOCSIFNETMASK, SIOCSIFNETMASK, "SIOCSIFNETMASK", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCGIFHWADDR, SIOCGIFHWADDR, "SIOCGIFHWADDR", do_struct_ioctl, _IOC_WRITE | _IOC_READ, sockaddr_ifreq_list },
  { X86_SIOCSIFHWADDR, SIOCSIFHWADDR, "SIOCSIFHWADDR", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCGIFMETRIC, SIOCGIFMETRIC, "SIOCGIFMETRIC", do_struct_ioctl, _IOC_WRITE | _IOC_READ, int_ifreq_list },
  { X86_SIOCSIFMETRIC, SIOCSIFMETRIC, "SIOCSIFMETRIC", do_struct_ioctl, _IOC_WRITE, int_ifreq_list },
  { X86_SIOCGIFMTU, SIOCGIFMTU, "SIOCGIFMTU", do_struct_ioctl, _IOC_WRITE | _IOC_READ, int_ifreq_list },
  { X86_SIOCSIFMTU, SIOCSIFMTU, "SIOCSIFMTU", do_struct_ioctl, _IOC_WRITE, int_ifreq_list },
  { X86_SIOCGIFMAP, SIOCGIFMAP, "SIOCGIFMAP", do_struct_ioctl, _IOC_WRITE | _IOC_READ, ifmap_ifreq_list },
  { X86_SIOCSIFMAP, SIOCSIFMAP, "SIOCSIFMAP", do_struct_ioctl, _IOC_WRITE, ifmap_ifreq_list },
  { X86_SIOCGIFSLAVE, SIOCGIFSLAVE, "SIOCGIFSLAVE", do_struct_ioctl, _IOC_WRITE | _IOC_READ, char_ifreq_list },
  { X86_SIOCSIFSLAVE, SIOCSIFSLAVE, "SIOCSIFSLAVE", do_struct_ioctl, _IOC_WRITE, char_ifreq_list },
  { X86_SIOCGIFMEM, SIOCGIFMEM, "SIOCGIFMEM", do_struct_ioctl, _IOC_WRITE | _IOC_READ, ptr_ifreq_list },
  { X86_SIOCSIFMEM, SIOCSIFMEM, "SIOCSIFMEM", do_struct_ioctl, _IOC_WRITE, ptr_ifreq_list },
  { X86_SIOCADDMULTI, SIOCADDMULTI, "SIOCADDMULTI", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCDELMULTI, SIOCDELMULTI, "SIOCDELMULTI", do_struct_ioctl, _IOC_WRITE, sockaddr_ifreq_list },
  { X86_SIOCSIFLINK, SIOCSIFLINK, "SIOCSIFLINK", do_void_ioctl, _IOC_NONE, 0 },
  { X86_SIOCGIFCONF, SIOCGIFCONF, "SIOCGIFCONF", do_struct_ioctl, _IOC_WRITE | _IOC_READ, ifconf_list },
  { X86_SIOCGIFENCAP, SIOCGIFENCAP, "SIOCGIFENCAP", do_ptr_ioctl, _IOC_WRITE | _IOC_READ, 0 },
  { X86_SIOCSIFENCAP, SIOCSIFENCAP, "SIOCSIFENCAP", do_ptr_ioctl, _IOC_WRITE, 0 },
  { X86_SIOCDARP, SIOCDARP, "SIOCDARP", do_struct_ioctl, _IOC_WRITE, arpreq_list },
  { X86_SIOCSARP, SIOCSARP, "SIOCSARP", do_struct_ioctl, _IOC_WRITE, arpreq_list },
  { X86_SIOCGARP, SIOCGARP, "SIOCGARP", do_struct_ioctl, _IOC_READ, arpreq_list },
  { X86_OLD_SIOCDARP, OLD_SIOCDARP, "OLD_SIOCDARP", do_struct_ioctl, _IOC_WRITE, arpreq_old_list },
  { X86_OLD_SIOCSARP, OLD_SIOCSARP, "OLD_SIOCSARP", do_struct_ioctl, _IOC_WRITE, arpreq_old_list },
  { X86_OLD_SIOCGARP, OLD_SIOCGARP, "OLD_SIOCGARP", do_struct_ioctl, _IOC_READ, arpreq_old_list },
  { X86_SIOCDRARP, SIOCDRARP, "SIOCDRARP", do_struct_ioctl, _IOC_WRITE, arpreq_list },
  { X86_SIOCSRARP, SIOCSRARP, "SIOCSRARP", do_struct_ioctl, _IOC_WRITE, arpreq_list },
  { X86_SIOCGRARP, SIOCGRARP, "SIOCGRARP", do_struct_ioctl, _IOC_READ, arpreq_list },
//  { X86_SIOCGIFBR, SIOCGIFBR, "SIOCGIFBR", do_struct_ioctl, _IOC_READ, br_stat_list },
//  { X86_SIOCSIFBR, SIOCSIFBR, "SIOCSIFBR", do_ptr_ioctl, _IOC_WRITE, 0 },
//  { X86_SIOCADDDLCI, SIOCADDDLCI, "SIOCADDDLCI", do_ptr_ioctl, _IOC_READ, 0 },
//  { X86_SIOCDELDLCI, SIOCDELDLCI, "SIOCDELDLCI", do_void_ioctl, _IOC_NONE, 0 },
  { 0, 0, 0, 0, 0 } };






