#include <syscall_thunk.h>
#include <errno.h>
#include <stdlib.h>

int	do_execve(unsigned int x86_filename, unsigned int *x86_argv, 
			unsigned int *x86_envp)
{
    int		argc, envc;
    char *	filename;
    char 	**argv;
    char	**envp;
    int		i;
    int		retval;

    /* Count up argc & envc so we can allocate memory to hold the
     * 64-bit pointers...
     */
    for(argc = 0; x86_argv[argc] != 0; argc++) ;
    for(envc= 0; x86_envp[envc] != 0; envc++) ;

    /* Thunk all the pointers... */
    filename = ARG_TO_POINTER(x86_filename);
    argv = malloc((argc+1)*sizeof(char *));
    envp = malloc((envc+1)*sizeof(char *));

    for(i = 0; i < argc; i++) {
	argv[i] = ARG_TO_POINTER(x86_argv[i]);
    }
    argv[i] = 0;

    for(i = 0; i < envc; i++) {
	envp[i] = ARG_TO_POINTER(x86_envp[i]);
    }
    envp[i] = 0;

    retval = execve(filename, argv, envp);

    /* If we get here, there's no question that something went wrong! */
    free(argv);
    free(envp);
    return(-alpha_to_intel_errno(errno));
}


