#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>

int	do_llseek(int a0, int a1, int a2, int a3, int a4, int a5)
{
    long retval;
    int fd = a0;
    long offset = ((long)a1 << 32) | ((long)a2 & 0xffffffff);
    long *resultp = ARG_TO_POINTER(a3);
    int whence = a4;

    /* lseek and llseek are really the same thing on Alpha */
    retval = lseek(fd, offset, whence);
    if(retval != -1) {
	*resultp = retval;
	return(0);
    }
    else {
	return(-alpha_to_intel_errno(errno));
    }
}


