/* Definitions for thunking the ioctl system call.  Unfortunately,
 * ioctl() is as hairy as all the rest of the system calls put
 * together!
 */

#ifndef _EM86_IOCTL_THUNK_H
#define _EM86_IOCTL_THUNK_H 1

#include <syscall_thunk.h>

#define X86_TCGETS          0x5401
#define X86_TCSETS          0x5402
#define X86_TCSETSW         0x5403
#define X86_TCSETSF         0x5404
#define X86_TCGETA          0x5405
#define X86_TCSETA          0x5406
#define X86_TCSETAW         0x5407
#define X86_TCSETAF         0x5408
#define X86_TCSBRK          0x5409
#define X86_TCXONC          0x540A
#define X86_TCFLSH          0x540B
#define X86_TIOCEXCL        0x540C
#define X86_TIOCNXCL        0x540D
#define X86_TIOCSCTTY       0x540E
#define X86_TIOCGPGRP       0x540F
#define X86_TIOCSPGRP       0x5410
#define X86_TIOCOUTQ        0x5411
#define X86_TIOCSTI         0x5412
#define X86_TIOCGWINSZ      0x5413
#define X86_TIOCSWINSZ      0x5414
#define X86_TIOCMGET        0x5415
#define X86_TIOCMBIS        0x5416
#define X86_TIOCMBIC        0x5417
#define X86_TIOCMSET        0x5418
#define X86_TIOCGSOFTCAR    0x5419
#define X86_TIOCSSOFTCAR    0x541A
#define X86_FIONREAD        0x541B
#define X86_TIOCINQ         X86_FIONREAD
#define X86_TIOCLINUX       0x541C
#define X86_TIOCCONS        0x541D
#define X86_TIOCGSERIAL     0x541E
#define X86_TIOCSSERIAL     0x541F
#define X86_TIOCPKT         0x5420
#define X86_FIONBIO         0x5421
#define X86_TIOCNOTTY       0x5422
#define X86_TIOCSETD        0x5423
#define X86_TIOCGETD        0x5424
#define X86_TCSBRKP         0x5425  /* Needed for POSIX tcsendbreak() */
#define X86_TIOCTTYGSTRUCT  0x5426  /* For debugging only */
#define X86_FIONCLEX        0x5450  /* these numbers need to be adjusted. */
#define X86_FIOCLEX         0x5451
#define X86_FIOASYNC        0x5452
#define X86_TIOCSERCONFIG   0x5453
#define X86_TIOCSERGWILD    0x5454
#define X86_TIOCSERSWILD    0x5455
#define X86_TIOCGLCKTRMIOS  0x5456
#define X86_TIOCSLCKTRMIOS  0x5457
#define X86_TIOCSERGSTRUCT  0x5458  /* For debugging only */
#define X86_TIOCSERGETLSR   0x5459  /* Get line status register */
#define X86_TIOCSERGETMULTI 0x545A  /* Get multiport config  */
#define X86_TIOCSERSETMULTI 0x545B  /* Set multiport config */
#define X86_TIOCMIWAIT      0x545C  /* wait for a change on serial input line(s) */
#define X86_TIOCGICOUNT     0x545D  /* read serial port inline interrupt counts */

/* Networking ioctls */
#define X86_SIOCADDRT       0x890B          /* add routing table entry */
#define X86_SIOCDELRT       0x890C          /* delete routing table entry */
#define X86_SIOCGIFNAME     0x8910          /* get iface name               */
#define X86_SIOCSIFLINK     0x8911          /* set iface channel            */
#define X86_SIOCGIFCONF     0x8912          /* get iface list               */
#define X86_SIOCGIFFLAGS    0x8913          /* get flags                    */
#define X86_SIOCSIFFLAGS    0x8914          /* set flags                    */
#define X86_SIOCGIFADDR     0x8915          /* get PA address               */
#define X86_SIOCSIFADDR     0x8916          /* set PA address               */
#define X86_SIOCGIFDSTADDR  0x8917          /* get remote PA address        */
#define X86_SIOCSIFDSTADDR  0x8918          /* set remote PA address        */
#define X86_SIOCGIFBRDADDR  0x8919          /* get broadcast PA address     */
#define X86_SIOCSIFBRDADDR  0x891a          /* set broadcast PA address     */
#define X86_SIOCGIFNETMASK  0x891b          /* get network PA mask          */
#define X86_SIOCSIFNETMASK  0x891c          /* set network PA mask          */
#define X86_SIOCGIFMETRIC   0x891d          /* get metric                   */
#define X86_SIOCSIFMETRIC   0x891e          /* set metric                   */
#define X86_SIOCGIFMEM      0x891f          /* get memory address (BSD)     */
#define X86_SIOCSIFMEM      0x8920          /* set memory address (BSD)     */
#define X86_SIOCGIFMTU      0x8921          /* get MTU size                 */
#define X86_SIOCSIFMTU      0x8922          /* set MTU size                 */
#define X86_SIOCSIFHWADDR   0x8924          /* set hardware address (NI)    */
#define X86_SIOCGIFENCAP    0x8925          /* get/set slip encapsulation   */
#define X86_SIOCSIFENCAP    0x8926
#define X86_SIOCGIFHWADDR   0x8927          /* Get hardware address         */
#define X86_SIOCGIFSLAVE    0x8929          /* Driver slaving support       */
#define X86_SIOCSIFSLAVE    0x8930
#define X86_SIOCADDMULTI    0x8931          /* Multicast address lists      */
#define X86_SIOCDELMULTI    0x8932

/* Bridging control calls */
#define X86_SIOCGIFBR       0x8940          /* Bridging support             */
#define X86_SIOCSIFBR       0x8941          /* Set bridging options         */


/* ARP cache control calls. */
#define X86_OLD_SIOCDARP    0x8950          /* old delete ARP table entry   */
#define X86_OLD_SIOCGARP    0x8951          /* old get ARP table entry      */
#define X86_OLD_SIOCSARP    0x8952          /* old set ARP table entry      */
#define X86_SIOCDARP        0x8953          /* delete ARP table entry       */
#define X86_SIOCGARP        0x8954          /* get ARP table entry          */
#define X86_SIOCSARP        0x8955          /* set ARP table entry          */

/* RARP cache control calls. */
#define X86_SIOCDRARP       0x8960          /* delete RARP table entry      */
#define X86_SIOCGRARP       0x8961          /* get RARP table entry         */
#define X86_SIOCSRARP       0x8962          /* set RARP table entry         */

/* Driver configuration calls */
#define X86_SIOCGIFMAP      0x8970          /* Get device parameters        */
#define X86_SIOCSIFMAP      0x8971          /* Set device parameters        */

/* DLCI configuration calls */
#define X86_SIOCADDDLCI     0x8980          /* Create new DLCI device       */
#define X86_SIOCDELDLCI     0x8981          /* Delete DLCI device           */

/* termios bit definitions */

/* c_iflag bits */
#define X86_IGNBRK  0000001
#define X86_BRKINT  0000002
#define X86_IGNPAR  0000004
#define X86_PARMRK  0000010
#define X86_INPCK   0000020
#define X86_ISTRIP  0000040
#define X86_INLCR   0000100
#define X86_IGNCR   0000200
#define X86_ICRNL   0000400
#define X86_IUCLC   0001000
#define X86_IXON    0002000
#define X86_IXANY   0004000
#define X86_IXOFF   0010000
#define X86_IMAXBEL 0020000

/* c_oflag bits */
#define X86_OPOST   0000001
#define X86_OLCUC   0000002
#define X86_ONLCR   0000004
#define X86_OCRNL   0000010
#define X86_ONOCR   0000020
#define X86_ONLRET  0000040
#define X86_OFILL   0000100
#define X86_OFDEL   0000200
#define X86_NLDLY   0000400
#define   X86_NL0   0000000
#define   X86_NL1   0000400
#define X86_CRDLY   0003000
#define   X86_CR0   0000000
#define   X86_CR1   0001000
#define   X86_CR2   0002000
#define   X86_CR3   0003000
#define X86_TABDLY  0014000
#define   X86_TAB0  0000000
#define   X86_TAB1  0004000
#define   X86_TAB2  0010000
#define   X86_TAB3  0014000
#define   X86_XTABS 0014000
#define X86_BSDLY   0020000
#define   X86_BS0   0000000
#define   X86_BS1   0020000
#define X86_VTDLY   0040000
#define   X86_VT0   0000000
#define   X86_VT1   0040000
#define X86_FFDLY   0100000
#define   X86_FF0   0000000
#define   X86_FF1   0100000

/* c_cflag bit meaning */
#define X86_CBAUD   0010017
#define  X86_B0     0000000         /* hang up */
#define  X86_B50    0000001
#define  X86_B75    0000002
#define  X86_B110   0000003
#define  X86_B134   0000004
#define  X86_B150   0000005
#define  X86_B200   0000006
#define  X86_B300   0000007
#define  X86_B600   0000010
#define  X86_B1200  0000011
#define  X86_B1800  0000012
#define  X86_B2400  0000013
#define  X86_B4800  0000014
#define  X86_B9600  0000015
#define  X86_B19200 0000016
#define  X86_B38400 0000017
#define X86_EXTA B19200
#define X86_EXTB B38400
#define X86_CSIZE   0000060
#define   X86_CS5   0000000
#define   X86_CS6   0000020
#define   X86_CS7   0000040
#define   X86_CS8   0000060
#define X86_CSTOPB  0000100
#define X86_CREAD   0000200
#define X86_PARENB  0000400
#define X86_PARODD  0001000
#define X86_HUPCL   0002000
#define X86_CLOCAL  0004000
#define X86_CBAUDEX 0010000
#define  X86_B57600  0010001
#define  X86_B115200 0010002
#define  X86_B230400 0010003
#define  X86_B460800 0010004
#define X86_CIBAUD    002003600000  /* input baud rate (not used) */
#define X86_CRTSCTS   020000000000          /* flow control */

/* c_lflag bits */
#define X86_ISIG    0000001
#define X86_ICANON  0000002
#define X86_XCASE   0000004
#define X86_ECHO    0000010
#define X86_ECHOE   0000020
#define X86_ECHOK   0000040
#define X86_ECHONL  0000100
#define X86_NOFLSH  0000200
#define X86_TOSTOP  0000400
#define X86_ECHOCTL 0001000
#define X86_ECHOPRT 0002000
#define X86_ECHOKE  0004000
#define X86_FLUSHO  0010000
#define X86_PENDIN  0040000
#define X86_IEXTEN  0100000

/* c_cc character offsets */
#define X86_VINTR	0
#define X86_VQUIT	1
#define X86_VERASE	2
#define X86_VKILL	3
#define X86_VEOF	4
#define X86_VTIME	5
#define X86_VMIN	6
#define X86_VSWTC	7
#define X86_VSTART	8
#define X86_VSTOP	9
#define X86_VSUSP	10
#define X86_VEOL	11
#define X86_VREPRINT	12
#define X86_VDISCARD	13
#define X86_VWERASE	14
#define X86_VLNEXT	15
#define X86_VEOL2	16


#define MAX_STRUCT_SIZE        4096
#define X86_TERMIOS_SIZE       36
#define ARRAY_TYPE_SHIFT       16
#define ARRAY_SIZE_MASK        0xffff
#define GET_ARRAY_TYPE(t)      (t >> ARRAY_TYPE_SHIFT)
#define GET_ARRAY_SIZE(s)      (s & ARRAY_SIZE_MASK)
#define MK_ARRAY_INFO(t,s)     ((t << ARRAY_TYPE_SHIFT)|(s & ARRAY_SIZE_MASK))

#define intel_to_alpha_ptr(ptr) ((unsigned long) ptr & 0xffffffff)
#define intel_to_alpha_long(val) intel_to_alpha_ptr(val)

typedef enum {
  TYPE_NULL,
  TYPE_CHAR,
  TYPE_SHORT,
  TYPE_INT,
  TYPE_LONG,
  TYPE_ULONG,
  TYPE_PTR,
  TYPE_ARRAY,
  SPECSTRUCT,      /* This marker shows beginning of special struct region */
  TYPE_TERMIOS,
  REGSTRUCT,       /* This marker shows all above are regular structs */
  TYPE_WINSIZE,
  TYPE_TQ_STRUCT,
  TYPE_ASYNC_STRUCT,
  TYPE_ASYNC_ICOUNT,
  TYPE_TTY_STRUCT,
  TYPE_TTY_DRIVER,
  TYPE_TTY_LDISC,
  TYPE_TTY_FLIP_BUFFER,
  TYPE_SERIAL_MULTIPORT_STRUCT,
  TYPE_SERIAL_ICOUNTER_STRUCT,
  TYPE_SOCKADDR,
  TYPE_RTENTRY,
  TYPE_IFMAP,
  TYPE_SOCKADDR_IFREQ,
  TYPE_SHORT_IFREQ,
  TYPE_INT_IFREQ,
  TYPE_IFMAP_IFREQ,
  TYPE_CHAR_IFREQ,
  TYPE_PTR_IFREQ,
  TYPE_IFCONF,
  TYPE_ARPREQ,
  TYPE_ARPREQ_OLD,
  TYPE_BR_STAT,
  TYPE_BRIDGE_DATA,
  TYPE_PORT_DATA,
  TYPE_BRIDGE_ID_T
} argtype;


/* ioctl_arguse: defines the device driver's usage of the argument: read-only,
 * return value back, or both
 */

typedef struct {
  int x86_cmd;
  int alpha_cmd;
  char *name;
  int (*routine)();
  /* keep this next field until some standards are imposed on ioctl #'s */
  int arguse;
  argtype *list;
} ioctl_descriptor;


extern bitmask_transtbl iflag_tbl [];
extern bitmask_transtbl oflag_tbl [];
extern bitmask_transtbl cflag_tbl [];
extern bitmask_transtbl lflag_tbl [];

extern ioctl_descriptor ioctl_table [];

extern argtype async_struct_list [];
extern argtype tq_struct_list [];
extern argtype async_icount_list [];
extern argtype tty_struct_list [];
extern argtype tty_flip_buffer_list [];
extern argtype tty_driver_list [];
extern argtype tty_ldisc_list [];
extern argtype winsize_list [];
extern argtype serial_multiport_struct_list [];
extern argtype serial_icounter_struct_list [];
extern argtype sockaddr_list [];
extern argtype rtentry_list [];
extern argtype ifmap_list [];
extern argtype sockaddr_ifreq_list [];
extern argtype short_ifreq_list [];
extern argtype int_ifreq_list [];
extern argtype ifmap_ifreq_list [];
extern argtype char_ifreq_list [];
extern argtype ptr_ifreq_list [];
extern argtype ifconf_list [];
extern argtype arpreq_list [];
extern argtype arpreq_old_list [];
extern argtype br_stat_list [];
extern argtype Bridge_data_list [];
extern argtype Port_data_list [];
extern argtype bridge_id_t_list [];

extern argtype *struct_table [];

int do_ptr_ioctl (int fd, ioctl_descriptor desc, int arg);
int do_struct_ioctl (int fd, ioctl_descriptor desc, int arg);
int do_termios_ioctl (int fd, ioctl_descriptor desc, int arg);
int do_int_ioctl (int fd, ioctl_descriptor desc, int arg);
int do_longptr_ioctl (int fd, ioctl_descriptor desc, int arg);
int do_void_ioctl (int fd, ioctl_descriptor desc, int arg);

#endif







